<?php
/*************************************************************************************
 *	Load scripts for front end
 *************************************************************************************/

function load_scripts_front(){
	$colour_options    = get_option('colour_options');
	$plugin_options    = get_option('plugin_options');
	$location_options  = get_option('location_options');
	$image_options     = get_option('image_options');
	if(!is_404()){
		$the_id = get_flight_id();
				
		$custom_background = (get_post_meta( $the_id, "background", true ) != "" ?  get_post_meta( $the_id, "background", true ) : "slideshow");
		
		if($custom_background != "slideshow"){
			$background_meta = explode(":", $custom_background);
			
			$the_background  = $background_meta[0];
			
			$background_info = ($the_background == "video" ? $background_meta[1] . ":" . $background_meta[2] : $background_meta[1]);
		}
	} else {
		$custom_background = "slideshow";
	}
	
	$display_inline = get_option("display_inline");
	$js_extension   = ($display_inline == "false" ? ".js"  : "_temp.php");
	
	// jQuery
    wp_enqueue_script( 'jquery' );
	
	// jQuery UI
	wp_deregister_script( 'jquery_ui' );
    wp_register_script( 'jquery_ui', "https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.16/jquery-ui.min.js");
    wp_enqueue_script( 'jquery_ui' );
    
  // jQuery Appear
	wp_deregister_script( 'jquery_appear' );
    wp_register_script( 'jquery_appear', get_template_directory_uri() . "/js/jquery/jquery.appear-1.1.1.min.js");
    wp_enqueue_script( 'jquery_appear' );
	
	// Modernizr
	wp_deregister_script( 'modernizr' );
    wp_register_script( 'modernizr', get_template_directory_uri() . "/js/modernizr/modernizr.min.js");
    wp_enqueue_script( 'modernizr' );
	
	// jQuery Easing
	wp_deregister_script( 'jquery_easing' );
    wp_register_script( 'jquery_easing', get_template_directory_uri() . "/js/jquery/jquery.easing.1.3.js");
    wp_enqueue_script( 'jquery_easing' );
	
	// jQuery Hover Intent
	wp_deregister_script( 'hoverint' );
    wp_register_script( 'hoverint', get_template_directory_uri() . "/js/jquery/jquery.hoverIntent.js");
    wp_enqueue_script( 'hoverint' );
	
	// Webfont
	wp_deregister_script( 'webfont' );
    wp_register_script( 'webfont', get_template_directory_uri() . "/js/fonts/webfont.js");
    wp_enqueue_script( 'webfont' );
	
	// Flight Menu
	$file = ($display_inline == "false" ? "/js/menus/flight.menu.js" : "/js/menus/menu_font.php");	
	wp_deregister_script( 'flight_menu' );
    wp_register_script( 'flight_menu', get_template_directory_uri() . $file);
    wp_enqueue_script( 'flight_menu' );
	
	// Flight Submenu
	if ( is_page_template('blog-page.php') || is_single() || is_page() || is_home() || is_front_page()) {
		wp_deregister_script( 'flight_submenu' );
		wp_register_script( 'flight_submenu', get_template_directory_uri() . "/js/menus/flight.submenu.js");
		wp_enqueue_script( 'flight_submenu' );
	}
	
	if($custom_background == "slideshow" || is_home()){
			if(is_page_template('location-fullscreen.php') === false){
				if(!class_exists("Mobile_Detect")){
					include 'Mobile_Detect.php';
				}
				
				$detect = new Mobile_Detect();
				
				
				
				if(isset($image_options['static_for_mobile']) && $image_options['static_for_mobile'] != "on" && $detect->isMobile()){
					// Slideshow JS
					wp_deregister_script( 'slideshow_js' );
					wp_register_script( 'slideshow_js', get_template_directory_uri() . "/js/slideshow/slideshow.js");
					wp_enqueue_script( 'slideshow_js' );
					
					// Slideshow Images
					wp_deregister_script( 'slideshow_images' );
					wp_register_script( 'slideshow_images', get_template_directory_uri() . "/js/slideshow/slideshow_content{$js_extension}");
					wp_enqueue_script( 'slideshow_images' );
				} elseif(!$detect->isMobile() && $custom_background == "slideshow"){
					// Slideshow JS
					wp_deregister_script( 'slideshow_js' );
					wp_register_script( 'slideshow_js', get_template_directory_uri() . "/js/slideshow/slideshow.js");
					wp_enqueue_script( 'slideshow_js' );
					
					// Slideshow Images
					wp_deregister_script( 'slideshow_images' );
					wp_register_script( 'slideshow_images', get_template_directory_uri() . "/js/slideshow/slideshow_content{$js_extension}");
					wp_enqueue_script( 'slideshow_images' );
				}
			} else {
				// Fullscreen Google Map
				wp_deregister_script( 'fullscreenmap' );
				wp_register_script( 'fullscreenmap', get_template_directory_uri() . "/js/maps/googlemap{$js_extension}");
				wp_enqueue_script( 'fullscreenmap' );
			}
	}
	// PrettyPhoto
	if( is_single() || is_page() || is_page_template('single-portfolio.php') ){
		wp_deregister_script( 'prettyPhoto' );
		wp_register_script( 'prettyPhoto', get_template_directory_uri() . "/js/lightbox/prettyPhoto.js");
		wp_enqueue_script( 'prettyPhoto' );
		
		wp_deregister_script( 'prettyPhotoJs' );
		wp_register_script( 'prettyPhotoJs', get_template_directory_uri() . "/js/lightbox/jquery.prettyPhoto.js");
		wp_enqueue_script( 'prettyPhotoJs' );
	}
	
	// Twitter
	if( is_active_widget(false, false, 'top_twitter_widget') || is_active_widget(false, false, 'footer_twitter_widget') ) {
		wp_deregister_script( 'twitter' );
		wp_register_script( 'twitter', get_template_directory_uri() . "/js/social/jquery.tweet.js");
		wp_enqueue_script( 'twitter' );
		
		$path = parse_url(get_template_directory_uri());
		
		wp_deregister_script( 'twitter_acc' );
		wp_register_script( 'twitter_acc', get_template_directory_uri() . "/js/social/twitter_feed.js");
		wp_enqueue_script( 'twitter_acc' );
		wp_localize_script( 'twitter_acc', 'info', array("url" => $path['path'] ) );
	}
	
	// Flickr
	if( is_active_widget(false, false, 'top_flickr_widget') ) {
		wp_deregister_script( 'flickr' );
		wp_register_script( 'flickr', get_template_directory_uri() . "/js/social/flickr{$js_extension}");
		wp_enqueue_script( 'flickr' );
	}
	
	// JWPlayer
	if(isset($the_background) && $the_background == "video"){
		wp_deregister_script( 'jwplayer' );
		wp_register_script( 'jwplayer', get_template_directory_uri() . "/js/jwplayer/jwplayer.js");
		wp_enqueue_script( 'jwplayer' );
	}
	
	// Instafeed
	if(is_active_widget(false, false, 'instagram-feed-widget')){
		wp_deregister_script( 'instafeed' );
		wp_register_script( 'instafeed', get_template_directory_uri() . "/js/social/instafeed.min.js");
		wp_enqueue_script( 'instafeed' );
	}
	
	// Placeholder (for IE)
	wp_deregister_script( 'placeholder' );
    wp_register_script( 'placeholder', get_template_directory_uri() . "/js/placeholder/placeholder.js");
    wp_enqueue_script( 'placeholder' );
	
	// Tipsy
	if(is_home() || is_single() || is_page()){
		wp_deregister_script( 'tipsy' );
    wp_register_script( 'tipsy', get_template_directory_uri() . "/js/editor/jquery.tipsy.js");
    wp_enqueue_script( 'tipsy' );
  }
	
	// Effects
	wp_deregister_script( 'effects' );
    wp_register_script( 'effects', get_template_directory_uri() . "/js/editor/effects.js");
    wp_enqueue_script( 'effects' );
	
	// Retina
	if(isset($plugin_options['retina']) && $plugin_options['retina'] != "off"){
		wp_deregister_script( 'retina' );
		wp_register_script( 'retina', get_template_directory_uri() . "/js/retina/retina.js");
		wp_enqueue_script( 'retina' );
	}
	
	// Google Map
	if(is_page_template('contact-page.php') || is_active_widget(false, false, 'google-map-widget')){	  
	  wp_deregister_script( 'googlemap' );
	  wp_register_script( 'googlemap', get_template_directory_uri() . "/js/maps/googlemap.contact{$js_extension}");
	  wp_enqueue_script( 'googlemap' );
  }
  
  // Google Map API
  if(is_page_template('contact-page.php') || is_page_template('location-fullscreen.php') || is_active_widget(false, false, 'google-map-widget')){
 	  wp_deregister_script( 'googlesmap' );
	  wp_register_script( 'googlesmap', 'http://maps.googleapis.com/maps/api/js?key=' . $location_options['maps_API'] . '&amp;sensor=false');
	  wp_enqueue_script( 'googlesmap' );
  }
  
  if (is_singular() && comments_open() && (get_option('thread_comments') == 1)){
	  wp_enqueue_script( 'comment-reply' );
  }
  
}
 
/*************************************************************************************
 *	Load styles for front end
 *************************************************************************************/
function load_styles_front() {
	global $post;
	
	$plugin_options = get_option('plugin_options');
	
	$the_id = get_flight_id();
	
	$colour_options = get_option('colour_options');
	$plugin_options = get_option('plugin_options');
	
	$colour_options['colour_scheme'] = (isset($colour_options['colour_scheme']) ? $colour_options['colour_scheme'] : "Robins Egg");
	
	$display_inline = get_option("display_inline");
	$css_extension  = ($display_inline == "false" ? ".css" : "_temp.php");
	$page_css       = get_post_meta( $the_id, 'css_style', true );
	
	$mobile_menu    = (isset($plugin_options['mobile_menu']) ? $plugin_options['mobile_menu'] : null);
		
	// Left/Right Menu
	$menu_position = (isset($plugin_options['menu_position']) && $plugin_options['menu_position'] == "right" ? "right" : "left");
	wp_deregister_style( 'menu_position' );
    wp_register_style( 'menu_position', get_template_directory_uri() . "/css/menu/" . $menu_position . ".css");
    wp_enqueue_style( 'menu_position' );
	
	// Luminosity
	$colour_options['luminosity'] = (isset($colour_options['luminosity']) ? $colour_options['luminosity'] : "");
	$luminosity                   = ($colour_options['luminosity'] == 'light' ? "light" : "dark");
	
	
	// Woocommerce Stylesheet Fix
	include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
	if(is_plugin_active('woocommerce/woocommerce.php')){
		if($luminosity == "dark" || $luminosity == "light"){
			wp_deregister_style( 'woocommerce-style' );
			wp_register_style( 'woocommerce-style', get_template_directory_uri() . "/css/options/woocommerce_" . $luminosity . ".css");
			wp_enqueue_style( 'woocommerce-style' );
				
			$woo_dir = WP_PLUGIN_URL . "/woocommerce/assets/fonts";
			$custom_css = "
			@font-face {
				font-family: 'star';
				src: url('" . $woo_dir . "/star.eot');
				src: url('" . $woo_dir . "/star.eot?#iefix') format('embedded-opentype'),url('" . $woo_dir . "/star.woff') format('woff'),url('" . $woo_dir . "/star.ttf') format('truetype'),url('" . $woo_dir . "/star.svg#star') format('svg');
				font-weight: normal;
				font-style: normal;
			}";
			wp_add_inline_style( 'woocommerce-style', $custom_css );
		}
	}
	
	// Options
	if(is_single() || is_page() || is_home() || is_search() || is_tag() || is_archive() || is_category()){
				
		generate_file("options", $dir = 'css/', $the_id);
		
		if(!file_exists(get_template_directory() . "/css/options/options-" . $the_id . ".css")){
			@generate_file("options", $dir = 'css/', $the_id);
		}
		
		if($css_extension != "_temp.php"){
			wp_deregister_style( 'options' );
			wp_register_style( 'options', get_template_directory_uri() . "/css/options/options-" . $the_id . "{$css_extension}");
			wp_enqueue_style( 'options' );
		}
	}
	
	$no_content_meta = (is_404() ? 0 : get_post_meta( $the_id, 'no_content', true ));
	
	// Fullscreen Location
	if(is_page_template('location-fullscreen.php') == true || $no_content_meta == "on"){
	   wp_deregister_style( 'fullscreenlocation' );
	   wp_register_style( 'fullscreenlocation', get_template_directory_uri() . "/css/menu/fullscreen.css");
	   wp_enqueue_style( 'fullscreenlocation' );
	}
	
	$used_google_fonts = array();
	
	// Heading Google Font
	$font_options    = get_option('font_options');
	$heading_explode = explode("|", $font_options['heading_fonts']);
	
	if(isset($font_options['heading_fonts']) && $font_options['heading_fonts'] != "" && count($heading_explode) != 1){	
		$search  = array("<link href='", "' rel='stylesheet' type='text/css'>");
		$replace = array("", ""); 
		
		$css_register = stripslashes(str_replace($search, $replace, $heading_explode[2]));
		if($heading_explode[0] != "" && $heading_exploded[0] != "default"){
		//<link href='http://fonts.googleapis.com/css?family=Pompiere' rel='stylesheet' type='text/css'>
		
		   preg_match_all('#\bhttps?://[^\s()<>]+(?:\([\w\d]+\)|([^[:punct:]\s]|/))#', $css_register, $match);
		   if(filter_var($match[0][0], FILTER_VALIDATE_URL) == true){
			   if(!in_array($match[0][0], $used_google_fonts)){
				   wp_deregister_style( 'google_heading_font' );
				   wp_register_style( 'google_heading_font', $match[0][0]);
				   wp_enqueue_style( 'google_heading_font' );
			   }
			   
			   array_push($used_google_fonts, $match[0][0]);
		   }
		}
	}
	
	// Body Google Font
	$font_options = get_option('font_options');
	$body_explode = explode("|", $font_options['body_fonts']);
	
	if(isset($font_options['body_fonts']) && $font_options['body_fonts'] != "" && count($body_explode) != 1){	
		$search  = array("<link href='", "' rel='stylesheet' type='text/css'>", "&lt;", "&gt;");
		$replace = array("", "", "<", ">"); 
		
		$body_font_current = htmlspecialchars(stripslashes($body_explode[2]));
		$css_register = str_replace($search, $replace, $body_font_current);
		
		$css_register = stripslashes(str_replace($search, $replace, $css_register));
		
		if($body_explode[0] != "" && $body_exploded[0] != "default"){
			//<link href='http://fonts.googleapis.com/css?family=Pompiere' rel='stylesheet' type='text/css'>
			preg_match_all('#\bhttps?://[^\s()<>]+(?:\([\w\d]+\)|([^[:punct:]\s]|/))#', $css_register, $match);
			if(filter_var($match[0][0], FILTER_VALIDATE_URL) == true){
			   if(!in_array($match[0][0], $used_google_fonts)){
				   wp_deregister_style( 'google_body_font' );
				   wp_register_style( 'google_body_font', $match[0][0]);
				   wp_enqueue_style( 'google_body_font' );	
			   }
			   
			   array_push($used_google_fonts, $match[0][0]);

			}
		}
	}
	
	// Slogan Google Font
	if(isset($font_options['slogan_fonts'])){
		$font_options   = get_option('font_options');
		$slogan_explode = explode("|", $font_options['slogan_fonts']);
		
		if(isset($font_options['slogan_fonts']) && $font_options['slogan_fonts'] != "" && count($slogan_explode) != 1){	
			$search  = array("<link href='", "' rel='stylesheet' type='text/css'>");
			$replace = array("", ""); 
			
			$css_register = stripslashes(str_replace($search, $replace, $slogan_explode[2]));
			if($slogan_explode[0] != "" && $slogan_exploded[0] != "default"){
				//<link href='http://fonts.googleapis.com/css?family=Pompiere' rel='stylesheet' type='text/css'>
				preg_match_all('#\bhttps?://[^\s()<>]+(?:\([\w\d]+\)|([^[:punct:]\s]|/))#', $css_register, $match);
				if(filter_var($match[0][0], FILTER_VALIDATE_URL) == true){
				   if(!in_array($match[0][0], $used_google_fonts)){
					   wp_deregister_style( 'google_slogan_font' );
					   wp_register_style( 'google_slogan_font', $match[0][0]);
					   wp_enqueue_style( 'google_slogan_font' );	
				   }
				   
				   array_push($used_google_fonts, $match[0][0]);
	  
				}
			}
		}
	}
	
	// Menu Google Font
	if(isset($font_options['menu_fonts'])){
		$font_options = get_option('font_options');
		$menu_explode = explode("|", $font_options['menu_fonts']);
		
		if(isset($font_options['menu_fonts']) && $font_options['menu_fonts'] != "" && count($menu_explode) != 1){	
			$search  = array("<link href='", "' rel='stylesheet' type='text/css'>");
			$replace = array("", ""); 
			
			$css_register = stripslashes(str_replace($search, $replace, $menu_explode[2]));
			if($menu_explode[0] != "" && $menu_explode[0] != "default"){
				//<link href='http://fonts.googleapis.com/css?family=Pompiere' rel='stylesheet' type='text/css'>
				preg_match_all('#\bhttps?://[^\s()<>]+(?:\([\w\d]+\)|([^[:punct:]\s]|/))#', $css_register, $match);
				if(filter_var($match[0][0], FILTER_VALIDATE_URL) == true){
				   if(!in_array($match[0][0], $used_google_fonts)){
					   wp_deregister_style( 'google_menu_font' );
					   wp_register_style( 'google_menu_font', $match[0][0]);
					   wp_enqueue_style( 'google_menu_font' );	
				   }
				   
				   array_push($used_google_fonts, $match[0][0]);
	
				}
			}
		}
	}
	
	// Menu Description Google Font
	if(isset($font_options['menudesc_fonts'])){
		$font_options     = get_option('font_options');
		$menudesc_explode = explode("|", $font_options['menudesc_fonts']);
		
		if(isset($font_options['menudesc_fonts']) && $font_options['menudesc_fonts'] != "" && count($menudesc_explode) != 1){	
			$search  = array("<link href='", "' rel='stylesheet' type='text/css'>");
			$replace = array("", ""); 
			
			$css_register = stripslashes(str_replace($search, $replace, $menudesc_explode[2]));
			if($menudesc_explode[0] != "" && $menudesc_explode[0] != "default"){
				//<link href='http://fonts.googleapis.com/css?family=Pompiere' rel='stylesheet' type='text/css'>
				preg_match_all('#\bhttps?://[^\s()<>]+(?:\([\w\d]+\)|([^[:punct:]\s]|/))#', $css_register, $match);
				if(filter_var($match[0][0], FILTER_VALIDATE_URL) == true){
				   if(!in_array($match[0][0], $used_google_fonts)){
					   wp_deregister_style( 'google_menudesc_font' );
					   wp_register_style( 'google_menudesc_font', $match[0][0]);
					   wp_enqueue_style( 'google_menudesc_font' );	
				   }
				   
				   array_push($used_google_fonts, $match[0][0]);
	
				}
			}
		}
	}
	
	// Font Stylesheet
	wp_deregister_style( 'font_stylesheet' );
	wp_register_style( 'font_stylesheet', get_template_directory_uri() . "/css/font{$css_extension}");
	wp_enqueue_style( 'font_stylesheet' );
	
	// PIE MMMMMMMMM
	wp_deregister_style( 'pie' );
    wp_register_style( 'pie', get_template_directory_uri() . "/css/pie{$css_extension}");
    wp_enqueue_style( 'pie' );
	
	if(isset($post->ID) && !empty($post->ID) && isset($page_css) && !empty($page_css) && $page_css != "none"){
		wp_deregister_style( 'main_style_color' );
		wp_register_style( 'main_style_color', get_template_directory_uri() . "/css/colors/" . strtolower(str_replace(" ", "-", $page_css)) . ".css");
		wp_enqueue_style( 'main_style_color' );
	} else {
		if($colour_options['colour_scheme'] == "custom"){
			wp_deregister_style( 'main_style_color' );
			wp_register_style( 'main_style_color', get_template_directory_uri() . "/css/colors/custom-colours{$css_extension}");
			wp_enqueue_style( 'main_style_color' );
		} else {
			wp_deregister_style( 'main_style_color' );
			wp_register_style( 'main_style_color', get_template_directory_uri() . "/css/colors/" . strtolower(str_replace(" ", "-", $colour_options['colour_scheme'])) . ".css");
			wp_enqueue_style( 'main_style_color' );
			
			// Mobile Menu Always On
			if($mobile_menu == "on"){
				wp_deregister_style( 'mobile_menu' );
				wp_register_style( 'mobile_menu', get_template_directory_uri() . "/css/colors/mobile/" . strtolower(str_replace(" ", "-", $colour_options['colour_scheme'])) . ".css");
				wp_enqueue_style( 'mobile_menu' );
				
				wp_deregister_style( 'mobile_menu_style' );
				wp_register_style( 'mobile_menu_style', get_template_directory_uri() . "/css/mobile_menu.css");
				wp_enqueue_style( 'mobile_menu_style' );
			}
		}
	}
	
	// Main Stylesheet
	wp_deregister_style( 'main_style' );
    wp_register_style( 'main_style', get_stylesheet_directory_uri() . "/style.css");
    wp_enqueue_style( 'main_style' );
	
	wp_deregister_style( 'luminosity' );
    wp_register_style( 'luminosity', get_template_directory_uri() . "/css/luminosity/" . $luminosity . ".css", "main_style");
    wp_enqueue_style( 'luminosity' );
	
	// Responsive Stylesheet
	if(isset($plugin_options['responsive']) && $plugin_options['responsive'] == "on" && is_page_template('location-fullscreen.php') == false && $no_content_meta != "on"){
		wp_deregister_style( 'responsive' );
		wp_register_style( 'responsive', get_template_directory_uri() . "/css/mobile.css");
		wp_enqueue_style( 'responsive' );
		
		wp_deregister_style( 'responsive-luminosity' );
		wp_register_style( 'responsive-luminosity', get_template_directory_uri() . "/css/luminosity/" . $luminosity . "-mobile.css");
		wp_enqueue_style( 'responsive-luminosity' );
	}
}
?>